Hands-On Lab:Build a basic RADIUS Test Server with FreeRADIUS 
Simulate authentication requests 
********************************************************************
Learning Outcome
-----------------
By the end of this lab, learners will be able to:

1. Install and start the FreeRADIUS service on Ubuntu.

2. Configure local user authentication using the FreeRADIUS “users” file.

3. Operate the FreeRADIUS service in both normal and debug modes.

4. Perform authentication tests using the radtest utility and interpret the results.

Procedure:
----------
1. Installation:
Update your Ubuntu system:
    sudo apt update && sudo apt upgrade

Install freeradius basic packages:
    sudo apt install freeradius freeradius-utils -y

Activating and starting FreeRADIUS:
    sudo systemctl enable freeradius
    sudo systemctl start freeradius
    sudo systemctl status freeradius


2. Basic Configuration (Local Users):
Edit the users file to define local users and their passwords:
    sudo nano /etc/freeradius/3.0/users
Add entries like:
    test_user Cleartext-Password := "your_password"
In our case we will use user "bob" and the password will be "hello" :
    bob Cleartext-Password := "hello"

Configure clients (Network Access Servers) in clients.conf:
    sudo nano /etc/freeradius/3.0/clients.conf

A test client, localhost, is provided in /etc/freeradius/3.0/clients.conf, with the secret testing123.

3. Service Management:
Restart the FreeRADIUS service after making configuration changes:
    sudo systemctl restart freeradius
For a soft reload without interrupting active sessions:
    sudo systemctl reload freeradius
run freeradius as debug mode:
    sudo systemctl stop freeradius
    sudo freeradius -X
    

Note: Start the FreeRADIUS server in debug mode only for testing. Other than for testing, use sudo systemctl start freeradius

sudo  freeradius -X

Expected output:
      [...]
      Listening on auth address * port 1812 bound to server default
      Listening on acct address * port 1813 bound to server default
      Listening on auth address :: port 1812 bound to server default
      Listening on acct address :: port 1813 bound to server default
      Listening on auth address 127.0.0.1 port 18120 bound to server inner-tunnel
      Listening on proxy address * port 54435
      Listening on proxy address :: port 58415
      Ready to process requests

The Listening and Ready to process requests appear when the server starts correctly.

    ctrl+C

For normal operation, start the service using:
     sudo systemctl start freeradius

4. Testing:
Use radtest to verify user authentication:
    radtest test_user your_password 127.0.0.1 0 my_shared_secret

Replace test_user, your_password, and my_shared_secret with your configured values.
  radtest bob hello 127.0.0.1 0 testing123

Expected output:
        Sent Access-Request Id 241 from 0.0.0.0:35234 to 127.0.0.1:1812 length 73
                User-Name = "bob"
                User-Password = "hello"
                NAS-IP-Address = 127.0.0.1
                NAS-Port = 0
                Message-Authenticator = 0x00
                Cleartext-Password = "hello"
        Received Access-Accept Id 241 from 127.0.0.1:1812 to 0.0.0.0:0 length 20

Summary of Learning Achievements

After completing this lab, learners should be able to:

1. Set up a functional FreeRADIUS server on Ubuntu.

2. Add and manage user authentication entries.

3. Configure and test a RADIUS client connection.

4. Run and interpret RADIUS debug logs for troubleshooting.